/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.event.EffectResolveEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SpellResolver {
    public AbstractCastMethod castType;
    public Spell spell;
    public SpellContext spellContext;
    public boolean silent;
    private final ISpellValidator spellValidator;
    @Nullable
    public HitResult hitResult = null;

    public SpellResolver(SpellContext spellContext) {
        this.spell = spellContext.getSpell();
        this.castType = spellContext.getSpell().getCastMethod();
        this.spellContext = spellContext;
        this.spellValidator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();
    }

    @Deprecated(forRemoval=true)
    public SpellResolver(ISpellCaster spellCaster, @Nullable LivingEntity castingEntity) {
        this(new SpellContext(spellCaster.getSpell(), castingEntity).withColors(spellCaster.getColor()));
    }

    public SpellResolver withSilent(boolean isSilent) {
        this.silent = isSilent;
        return this;
    }

    public boolean canCast(LivingEntity entity) {
        List<SpellValidationError> validationErrors = this.spellValidator.validate(this.spell.recipe);
        if (validationErrors.isEmpty()) {
            return this.enoughMana(entity);
        }
        if (!this.silent && !entity.m_20193_().f_46443_) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)validationErrors.get(0).makeTextComponentExisting());
        }
        return false;
    }

    boolean enoughMana(LivingEntity entity) {
        Player player;
        boolean canCast;
        int totalCost = this.getCastingCost(this.spell, entity);
        IManaCap manaCap = (IManaCap)CapabilityRegistry.getMana(entity).orElse(null);
        if (manaCap == null) {
            return false;
        }
        boolean bl = canCast = (double)totalCost <= manaCap.getCurrentMana() || entity instanceof Player && (player = (Player)entity).m_7500_();
        if (!(canCast || entity.m_20193_().f_46443_ || this.silent)) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)new TranslatableComponent("ars_nouveau.spell.no_mana"));
        }
        return canCast;
    }

    public boolean postEvent() {
        return SpellUtil.postEvent(new SpellCastEvent(this.spellContext.caster, this.spell, this.spellContext));
    }

    private SpellStats getCastStats() {
        LivingEntity caster = this.spellContext.caster;
        return new SpellStats.Builder().setAugments(this.spell.getAugments(0, caster)).addItemsFromEntity(caster).build(this.castType, this.hitResult, caster.f_19853_, caster, this.spellContext);
    }

    public boolean onCast(ItemStack stack, Level level) {
        if (this.canCast(this.spellContext.caster) && !this.postEvent()) {
            this.hitResult = null;
            this.castType.onCast(stack, this.spellContext.caster, level, this.getCastStats(), this.spellContext, this);
            return true;
        }
        return false;
    }

    public boolean onCastOnBlock(BlockHitResult blockRayTraceResult) {
        if (this.canCast(this.spellContext.caster) && !this.postEvent()) {
            this.hitResult = blockRayTraceResult;
            this.castType.onCastOnBlock(blockRayTraceResult, this.spellContext.caster, this.getCastStats(), this.spellContext, this);
            return true;
        }
        return false;
    }

    public boolean onCastOnBlock(UseOnContext context) {
        if (this.canCast(this.spellContext.caster) && !this.postEvent()) {
            this.hitResult = context.f_43705_;
            this.castType.onCastOnBlock(context, this.getCastStats(), this.spellContext, this);
            return true;
        }
        return false;
    }

    public boolean onCastOnEntity(ItemStack stack, Entity target, InteractionHand hand) {
        if (this.canCast(this.spellContext.caster) && !this.postEvent()) {
            this.hitResult = new EntityHitResult(target);
            this.castType.onCastOnEntity(stack, this.spellContext.caster, target, hand, this.getCastStats(), this.spellContext, this);
            return true;
        }
        return false;
    }

    public void onResolveEffect(Level world, HitResult result) {
        this.hitResult = result;
        this.resolveAllEffects(world);
    }

    protected void resolveAllEffects(Level world) {
        AbstractSpellPart part;
        this.spellContext.resetCastCounter();
        LivingEntity shooter = this.spellContext.getUnwrappedCaster(world);
        SpellResolveEvent.Pre spellResolveEvent = new SpellResolveEvent.Pre(world, shooter, this.hitResult, this.spell, this.spellContext);
        MinecraftForge.EVENT_BUS.post((Event)spellResolveEvent);
        if (spellResolveEvent.isCanceled()) {
            return;
        }
        while (this.spellContext.hasNextPart() && (part = this.spellContext.nextPart()) != null) {
            AbstractEffect effect;
            EffectResolveEvent.Pre preEvent;
            if (part instanceof AbstractAugment) continue;
            SpellStats.Builder builder = new SpellStats.Builder();
            List<AbstractAugment> augments = this.spell.getAugments(this.spellContext.getCurrentIndex() - 1, shooter);
            SpellStats stats = builder.setAugments(augments).addItemsFromEntity(shooter).build(part, this.hitResult, world, shooter, this.spellContext);
            if (!(part instanceof AbstractEffect) || MinecraftForge.EVENT_BUS.post((Event)(preEvent = new EffectResolveEvent.Pre(world, shooter, this.hitResult, this.spell, this.spellContext, effect = (AbstractEffect)part, stats)))) continue;
            effect.onResolve(this.hitResult, world, shooter, stats, this.spellContext, this);
            MinecraftForge.EVENT_BUS.post((Event)new EffectResolveEvent.Post(world, shooter, this.hitResult, this.spell, this.spellContext, effect, stats));
        }
        MinecraftForge.EVENT_BUS.post((Event)new SpellResolveEvent.Post(world, shooter, this.hitResult, this.spell, this.spellContext));
    }

    public void expendMana(LivingEntity entity) {
        int totalCost = this.getCastingCost(this.spell, entity);
        CapabilityRegistry.getMana(entity).ifPresent(mana -> mana.removeMana(totalCost));
    }

    public int getCastingCost(Spell spell, LivingEntity e) {
        int cost = spell.getCastingCost() - ManaUtil.getPlayerDiscounts(e);
        return Math.max(cost, 0);
    }

    public SpellResolver getNewResolver(SpellContext context) {
        return new SpellResolver(context);
    }

    public boolean hasFocus(ItemStack stack) {
        return CuriosUtil.hasItem(this.spellContext.caster, stack);
    }

    @Deprecated(forRemoval=true)
    public static LivingEntity getUnwrappedCaster(Level world, SpellContext spellContext) {
        Object shooter = spellContext.getCaster();
        if (shooter == null && spellContext.castingTile != null) {
            shooter = ANFakePlayer.getPlayer((ServerLevel)world);
            BlockPos pos = spellContext.castingTile.m_58899_();
            shooter.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }
        shooter = shooter == null ? ANFakePlayer.getPlayer((ServerLevel)world) : shooter;
        return shooter;
    }

    @Deprecated(forRemoval=true)
    public boolean postEvent(LivingEntity entity) {
        return this.postEvent();
    }

    @Deprecated(forRemoval=true)
    private SpellStats getCastStats(LivingEntity caster) {
        return this.getCastStats();
    }

    @Deprecated(forRemoval=true)
    public boolean onCastOnEntity(ItemStack stack, LivingEntity playerIn, Entity target, InteractionHand hand) {
        return this.onCastOnEntity(stack, target, hand);
    }

    @Deprecated(forRemoval=true)
    public boolean onCast(ItemStack stack, LivingEntity caster, Level world) {
        return this.onCast(stack, world);
    }

    @Deprecated(forRemoval=true)
    public boolean onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster) {
        return this.onCastOnBlock(blockRayTraceResult);
    }

    @Deprecated(forRemoval=true)
    public void onResolveEffect(Level world, LivingEntity shooter, HitResult result) {
        this.onResolveEffect(world, result);
    }

    @Deprecated(forRemoval=true)
    public static void resolveEffects(Level world, LivingEntity shooter, HitResult result, Spell spell, SpellContext spellContext) {
        SpellResolver resolver = new SpellResolver(spellContext);
        resolver.hitResult = result;
        resolver.resolveAllEffects(world);
    }

    @Deprecated(forRemoval=true)
    public boolean wouldAllEffectsDoWork(HitResult result, Level world, LivingEntity entity, SpellStats stats) {
        for (AbstractSpellPart spellPart : this.spell.recipe) {
            if (!(spellPart instanceof AbstractEffect) || ((AbstractEffect)spellPart).wouldSucceed(result, world, entity, stats, this.spellContext)) continue;
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public boolean wouldCastOnBlockSuccessfully(BlockHitResult blockRayTraceResult, LivingEntity caster) {
        return this.castType.wouldCastOnBlockSuccessfully(blockRayTraceResult, caster, this.getCastStats(caster), this);
    }
}

